### Name: mappings
### Title: Map between probes, probesets, exons, transcripts and genes
### Aliases: mappings probeset.to.probe probeset.to.exon
###   probeset.to.transcript probeset.to.gene exon.to.probeset
###   exon.to.transcript exon.to.gene transcript.to.probeset
###   transcript.to.exon transcript.to.gene gene.to.probeset gene.to.exon
###   gene.to.transcript symbol.to.gene symbol.to.probeset
###   gene.to.exon.probeset gene.to.exon.probeset.expr exon.to.sequence
### Keywords: misc

### ** Examples

  if(interactive()) {
    xmapConnect()
    probeset.to.gene(c("3743919"))
    probeset.to.gene(c("3743919"),as.vector=FALSE)
    probeset.to.gene(c("3743919","3743919"),as.vector=FALSE,unique=TRUE)
    gene <-  probeset.to.gene(c("3743919"))
    gene.to.probeset(gene,as.vector=TRUE)
    gene.to.exon.probeset(gene)
  }



