### Name: interpolateHelper
### Title: Quantile Adjustment interpolator
### Aliases: interpolateHelper
### Keywords: algebra

### ** Examples

y<-matrix(rnbinom(10000,size=2,mu=10),ncol=4)
d<-DGEList(data=y,group=rep(1:2,each=2),lib.size=rep(c(1000,1010),2))
ps<-estimatePs(d,r=2)
N<-prod(d$lib.size)^(1/ncol(d$data))
perc<-pnbinom(d$data-1,size=2,mu=outer(ps$p.common,d$lib.size))+dnbinom(d$data,size=2,mu=outer(ps$p.common,d$lib.size))/2
maxcounts<-apply(d$data,1,max)
pseudo<-interpolateHelper(outer(ps$p.common,rep(N,4)),perc,r=2,maxcounts)



