### Name: dyebias.trendplot
### Title: Creates a trend-plot of all reporters, binned by dye bias, with
###   all slides ordered by slide bias.
### Aliases: dyebias.trendplot
### Keywords: hplot misc

### ** Examples


  ## Don't show: 
     options(stringsAsFactors = FALSE)

     library(dyebias)
     library(dyebiasexamples)
     data(data.raw)
     data(data.norm)

     ### obtain estimate for the iGSDBs:
     iGSDBs.estimated <- dyebias.estimate.iGSDBs(data.norm,
                                                 is.balanced=TRUE,
                                                 verbose=FALSE)

     ### choose the estimators and which spots to correct:
     estimator.subset <- dyebias.umcu.proper.estimators(maInfo(maGnames(data.norm)))

     application.subset <- maW(data.norm) == 1 &
                   dyebias.application.subset(data.raw=data.raw, use.background=TRUE)

     ### do the correction:
     correction <- dyebias.apply.correction(data.norm=data.norm,
                                            iGSDBs = iGSDBs.estimated,
                                            estimator.subset=estimator.subset,
                                            application.subset = application.subset,
                                            verbose=FALSE)
  ## End Don't show                                     

  ## show trend plots of uncorrected and corrected next to each other:
  ylim <- c(-0.6, 0.6)

  layout(matrix(1:2, nrow=1,ncol=2))

  order <- dyebias.trendplot(data=data.norm, 
                        iGSDBs=iGSDBs.estimated, # from e.g. dyebias.estimate.iGSDBs
                        order=NULL,              # i.e., order by increasing slide bias
                        output=NULL,
                        main="before correction",
                        ylim=ylim
                        )

  order <- dyebias.trendplot(data=correction$data.corrected, # from dyebias.apply.correction
                        iGSDBs=iGSDBs.estimated,
                        order=order,             # order by the original slide bias
                        output=NULL,
                        main="after correction",
                        ylim=ylim
                       ) 




