### Name: dyebias.application.subset
### Title: Return a subset of reporters that can be dye bias-corrected
###   reasonably well
### Aliases: dyebias.application.subset
### Keywords: misc

### ** Examples

  ## First load data and estimate the iGSDBs
  ## (see dyebias.estimate.iGSDBs)

  ## Don't show: 
     options(stringsAsFactors = FALSE)

     library(dyebias)
     library(dyebiasexamples)
     data(data.raw)
     data(data.norm)

     ### obtain estimate for the iGSDBs:
     iGSDBs.estimated <- dyebias.estimate.iGSDBs(data.norm,
                                              is.balanced=TRUE,
                                              verbose=FALSE)
  ## End Don't show                                    

  ### choose the estimators and which spots to correct:
  estimator.subset <- dyebias.umcu.proper.estimators(maInfo(maGnames(data.norm)))

  ### choose which genes to dye bias correct. Typically, this is based
  ### both on flagged spots and intensity
  application.subset <- maW(data.norm) == 1 &
          dyebias.application.subset(data.raw=data.raw, use.background=TRUE)

  summary(application.subset)




