### Name: cosmo
### Title: Constrained motif detection main function
### Aliases: cosmo
### Keywords: misc

### ** Examples

## initialize constraint set
## consisting of three intervals
## 1st and 3rd intervals are 3bp long
## middle interval is variable lenght
conSet <- makeConSet(numInt=3, type=c("B","V","B"),length=c(3,NA,3))

## construct two bound constraints
boundCon1 <- makeBoundCon(lower=1.0, upper=2.0)
boundCon2 <- makeBoundCon(lower=0.0, upper=1.0)

## construct palindromic constraint
## require intervals 1 and 3 to be palindromes
## to within 0.05 tolerance
palCon1 <- makePalCon(int1=1, int2=3, errBnd=0.05)

## add constraints to initial constraint set
constraint <- list(boundCon1, boundCon2, palCon1)
int <- list(1, 2, NA)
conSet <- addCon(conSet=conSet, constraint=constraint, int=int)

## path to example sequence file in FASTA format
seqFile <- system.file("Exfiles","seq.fasta",package="cosmo")

## search for motifs of width 8
## assume zero or one occurrences of motif per sequence (ZOOPS)
res <- cosmo(seqs=seqFile, constraints=conSet, minW=8, maxW=8, models="ZOOPS")
plot(res)



