###################################################
### chunk number 1: 
###################################################
require("cghMCR")
data("sampleData")


###################################################
### chunk number 2: 
###################################################
maNsamples(sampleData)
length(maLabels(maGnames(sampleData)))


###################################################
### chunk number 3: 
###################################################
segments <- getSegments(sampleData)


###################################################
### chunk number 4: 
###################################################
names(segments)


###################################################
### chunk number 5: 
###################################################
cghmcr <- cghMCR(segments, gapAllowed = 500, alteredLow = 0.20,
                   alteredHigh = 0.80, recurrence = 50)
mcrs <- MCR(cghmcr)


###################################################
### chunk number 6: 
###################################################
print(cbind(mcrs[, c("chromosome", "status", "mcr.start", "mcr.end", 
                     "samples")])) 


###################################################
### chunk number 7: 
###################################################
mcrs <- mergeMCRProbes(mcrs, segments[["data"]])
print(cbind(mcrs[, c("chromosome", "status", "mcr.start", "mcr.end", 
                     "probes")]))


###################################################
### chunk number 8: 
###################################################
sessionInfo()


