###################################################
### chunk number 1: 
###################################################
library("biocViews")
library("Biobase")


###################################################
### chunk number 2: VocabDefinition
###################################################
vocabFile <- system.file("dot/biocViewsVocab.dot", package="biocViews")
cat(readLines(vocabFile)[1:20], sep="\n")
cat("...\n")


###################################################
### chunk number 3: getViews
###################################################
data(biocViewsVocab)
reposPath <- system.file("doc", package="biocViews")
reposUrl <- paste("file://", reposPath, sep="")
biocViews <- getBiocSubViews(reposUrl, biocViewsVocab, topTerm="Software")

print(biocViews[1:2])



###################################################
### chunk number 4: listTerms
###################################################
getSubTerms(biocViewsVocab, term="AssayTechnologies")


###################################################
### chunk number 5: htmlViewsGen
###################################################
viewsDir <- file.path(tempdir(), "biocViews")
dir.create(viewsDir)
writeBiocViews(biocViews, dir=viewsDir)

dir(viewsDir)[1:2]


