### Name: symbolsInteresting
### Title: Useful for changing the look of pairs plots to emphasize
###   concordant or discordant genes
### Aliases: symbolsInteresting
### Keywords: dplot

### ** Examples


  data(expressionSetList)
  data(xmcmc)
  pathToLogFiles <- system.file("logFiles", package="XDE")
  load(file.path(pathToLogFiles, "BES.rda"))
  load(file.path(pathToLogFiles, "postAvg.rda"))
  op.conc <- symbolsInteresting(rankingStatistic=postAvg[, "concordant"])
  graphics:::pairs(BES[op.conc$order, ], pch=op.conc$pch, col=op.conc$col, 
                   bg=op.conc$bg, upper.panel=NULL, cex=op.conc$cex)  




