### Name: SolexaPath-class
### Title: "SolexaPath" class representing a standard output file hierarchy
### Aliases: SolexaPath-class SolexaPath SolexaSet,SolexaPath-method
###   qa,SolexaPath-method report,SolexaPath-method show,SolexaPath-method
###   detail,SolexaPath-method readIntensities,SolexaPath-method
###   readPrb,SolexaPath-method readQseq,SolexaPath-method
###   readFastq,SolexaPath-method readBaseQuality,SolexaPath-method
###   readAligned,SolexaPath-method
### Keywords: classes

### ** Examples

showClass("SolexaPath")
showMethods(class="SolexaPath")
sf <- system.file("extdata", package="ShortRead")
sp <- SolexaPath(sf)
sp
readFastq(sp, pattern="s_1_sequence.txt")
## Not run: 
##D nfiles <- length(list.files(analysisPath(sp), "s_[1-8]_export.txt"))
##D library(Rmpi)
##D mpi.spawn.Rslaves(nslaves=nfiles)
##D report(qa(sp))
## End(Not run)



