### Name: RtreemixModel-class
### Title: Class "RtreemixModel"
### Aliases: CompleteMat Resp Star Trees Weights WeightsCI getTree
###   getData,RtreemixModel numTrees Weights<- RtreemixModel-class
###   CompleteMat,RtreemixModel-method Resp,RtreemixModel-method
###   Star,RtreemixModel-method Trees,RtreemixModel-method
###   Weights,RtreemixModel-method Weights<-,RtreemixModel-method
###   WeightsCI,RtreemixModel-method getData,RtreemixModel-method
###   getTree,RtreemixModel,numeric-method numTrees,RtreemixModel-method
###   initialize,RtreemixModel-method print,RtreemixModel-method
###   show,RtreemixModel-method 'plot,RtreemixModel-method, missing-method'
### Keywords: classes

### ** Examples

## Generate a random RtreemixModel object with 2 components.
rand.mod <- generate(K = 2, no.events = 9, noise.tree = TRUE, prob = c(0.2, 0.8))
show(rand.mod)
plot(rand.mod) ## plot the tree components of the model
plot(rand.mod, k = 2) ## plot the second component of the model

## Draw data from a specified mixture model.
draws <- sim(model = rand.mod, no.draws = 200)
show(draws)

## Create an RtreemixModel object by fitting model to the drawn data.
mod <- fit(data = draws, K = 2, equal.edgeweights = TRUE, noise = TRUE)
show(mod)

## See the values of the slots of the RtreemixModel object.
Weights(mod)
Resp(mod)
CompleteMat(mod)
Star(mod)
Trees(mod)
## See data used for learning the model.
getData(mod)
## See the number of tree components in the mixture model.
numTrees(mod)
## See a specific tree component k.
getTree(object = mod, k = 2)
## See the conditional probabilities assigned to edges of the second tree component.
edgeData(getTree(object = mod, k = 2), attr = "weight")
## See the probability distribution encoded by the model on the set of all possible patterns.
distr <- distribution(model = mod)
distr
## Get the probabilities.
distr$probability
## See the probability distribution encoded by the model on the set of all possible patterns
## calculated for given sampling mode, and input and output parameters.
distr1 <- distribution(model = mod, sampling.mode = "exponential", sampling.param = 1, output.param = 1)
distr1

## Create a RtreemixModel and analyze its variance with the bootstrap method.
mod.boot <- bootstrap(data = draws, K = 2, equal.edgeweights = TRUE, B = 100)

## See the confidence intervals for the mixture parameters (the weights).
WeightsCI(mod.boot)
## See the confidence intervals of the conditional probabilities assigned to the edges.
edgeData(getTree(mod.boot, 2), attr = "ci")



