### Name: layoutGraph
### Title: A function to compute layouts of graph objects
### Aliases: layoutGraph
### Keywords: graphs

### ** Examples

library(graph)
set.seed(123)
V <- letters[1:5]
M <- 1:2
g1 <- randomGraph(V, M, 0.5)
edgemode(g1) <- "directed"
x <- layoutGraph(g1)
renderGraph(x)

## one of Graphviz's additional layout algorithms
x <- layoutGraph(g1, layoutType="neato")
renderGraph(x)

## some tweaks to Graphviz's node and edge attributes,
## including a user-defined arrowhead and node shape functions.
myArrows <- function(x, ...)
{
for(i in 1:4)
points(x,cex=i)
}

myNode <- function(x, col, fill, ...)
symbols(x=mean(x[,1]), y=mean(x[,2]), thermometers=cbind(.5, 1,
runif(1)), inches=0.5,
fg=col, bg=fill, add=TRUE)

eAtt <- list(arrowhead=c("a~b"=myArrows, "b~d"="odiamond", "d~e"="tee"))
nAtt <- list(shape=c(d="box", c="ellipse", a=myNode))
edgemode(g1) <- "directed"
x <- layoutGraph(g1, edgeAttrs=eAtt, nodeAttrs=nAtt, layoutType="neato")
renderGraph(x)




