### Name: vennDiag
### Title: Plotting a Venn Diagram to compare hits
### Aliases: vennDiag
### Keywords: device

### ** Examples

data(exampleHeader, package="RNAither")

data(pValVec1, package="RNAither")
data(pValVec2, package="RNAither")
data(scoredDataset1, package="RNAither")
data(scoredDataset2, package="RNAither")

##for details on the generation of pValVec and scoredDataset, 
##see the examples of the functions Ttest and MannWhitney linked above.

scoredHits1 <- hitselectionPval(scoredDataset1, pValVec1, "SigIntensity", "pValue.ttest_l", 0.05, 
"GeneName", "pvalue_testfile1.txt")

scoredHits2 <- hitselectionPval(scoredDataset2, pValVec2, "SigIntensity", "pValue.mannwhitney_l", 0.05, 
"GeneName", "pvalue_testfile2.txt")

hitvector1 <- scoredHits1[[2]]
hitvector2 <- scoredHits2[[2]]

plot_name <- vennDiag(header, list(hitvector1, hitvector2), list("t test", "Mann-Whitney test"), 
"Venn diagram", 1)



