### Encoding: latin1

### Name: nem
### Title: Spatial Classification by EM algorithm
### Aliases: nem nem.default nem.arrayCGH
### Keywords: spatial models

### ** Examples

data(spatial)  ## arrays with local spatial effects

## Plot of LogRatio measured on the array CGH
## Not run: 
##D arrayPlot(edge,"LogRatio", main="Log2-Ratio measured on the array
##D CGH", zlim=c(-1,1), bar="v", mediancenter=TRUE) 
## End(Not run)

## Spatial trend of the scaled log-ratios (the variable "ScaledLogRatio"
## equals to the log-ratio minus the median value of the corresponding chromosome arm) 
edgeTrend <- arrayTrend(edge, variable="ScaledLogRatio",
span=0.03, degree=1, iterations=3, family="symmetric")

## Not run: 
##D arrayPlot(edgeTrend, variable="Trend", main="Spatial trend of the array CGH", bar="v") 
## End(Not run)

## Classification with spatial constraint of the spatial trend
edgeNem <- nem(edgeTrend, variable="Trend")
## Not run: 
##D arrayPlot(edgeNem, variable="ZoneNem", main="Spatial zones identified by nem", bar="v")
## End(Not run)



