### Encoding: latin1

### Name: detectSB
### Title: Spatial bias detection
### Aliases: detectSB detectSB.default detectSB.arrayCGH
### Keywords: models spatial

### ** Examples

data(spatial)  ## arrays with local spatial effects

## Plot of LogRatio measured on the array CGH
arrayPlot(edge,"LogRatio", main="Log2-Ratio measured on the array
CGH", zlim=c(-1,1), bar="v", mediancenter=TRUE) 

## Spatial trend of the scaled log-ratios (the variable "ScaledLogRatio"
## equals to the log-ratio minus the median value of the corresponding
## chromosome arm)

edgeTrend <- arrayTrend(edge, variable="ScaledLogRatio",
span=0.03, degree=1, iterations=3, family="symmetric")   
arrayPlot(edgeTrend, variable="Trend", main="Spatial trend of the
array CGH", bar="v")  

## Not run: 
##D ## Classification with spatial constraint of the spatial trend
##D edgeNem <- nem(edgeTrend, variable="Trend")
##D arrayPlot(edgeNem, variable="ZoneNem", main="Spatial zones identified
##D by nem", bar="v") 
##D 
##D # Detection of spatial bias
##D edgeDet <- detectSB(edgeNem, variable="LogRatio", proportionup=0.25,type="up", thresholdup=0.15) 
##D arrayPlot(edgeDet, variable="SB", main="Zone of spatial bias in red", bar="v")
##D 
##D # CGH profile 
##D plot(LogRatio ~ PosOrder, data=edgeDet$arrayValues,
##D col=c("black","red")[as.factor(SB)], pch=20, main="CGH profile: spots
##D located in spatial bias are in red")  
## End(Not run)



