### Name: neighborhood
### Title: Return the neighborhood set of given vertices
### Aliases: neighborhood


### ** Examples

  V <- c("Hamburg","Stuttgart","Berlin","Paris","Bremen")
  E <- list("Hamburg"=c("Berlin","Bremen"),
            "Stuttgart"=c("Berlin","Paris"),
            "Berlin"=c("Stuttgart","Bremen"),
            "Paris"=c("Stuttgart"),
            "Bremen"=c("Hamburg","Berlin"))
  g <- new("graphNEL", nodes=V, edgeL=E, edgemode="directed")
  if(require(Rgraphviz) & interactive()) {
    plot(g, "neato")
  }

  ## simple uses
  neighborhood(g, "Hamburg")
  neighborhood(g, c("Hamburg", "Berlin","Paris"))

  ## in case of non-existing nodes
  neighborhood(g, c("Stuttgart","Ulm"))

  ## also applicable to non-directed graphs
  neighborhood(ugraph(g), c("Stuttgart","Berlin"))



