### Name: nearest
### Title: Nearest neighbor finding
### Aliases: nearest precede follow nearest,Ranges,RangesORmissing-method
###   precede,Ranges,RangesORmissing-method
###   follow,Ranges,RangesORmissing-method
### Keywords: utilities

### ** Examples

  query <- IRanges(c(1, 3, 9), c(2, 7, 10))
  subject <- IRanges(c(3, 5, 12), c(3, 6, 12))

  nearest(query, subject) # c(1L, 1L, 3L)
  nearest(query) # c(2L, 1L, 2L)

  query <- IRanges(c(1, 3, 9), c(3, 7, 10))
  subject <- IRanges(c(3, 2, 10), c(3, 13, 12))
  
  precede(query, subject) # c(3L, 3L, NA)
  precede(IRanges(), subject) # integer()
  precede(query, IRanges()) # rep(NA_integer_, 3)
  precede(query) # c(3L, 3L, NA)
  
  follow(query, subject) # c(NA, NA, 1L)
  follow(IRanges(), subject) # integer()
  follow(query, IRanges()) # rep(NA_integer_, 3)
  follow(query) # c(NA, NA, 2L)



