### Name: XDataFrame-class
### Title: External Data Frame
### Aliases: XDataFrame-class dim,XDataFrame-method
###   dimnames,XDataFrame-method dimnames<-,XDataFrame-method XDataFrame
###   [,XDataFrame-method [[,XDataFrame-method [[<-,XDataFrame-method
###   as.data.frame,XDataFrame-method coerce,ANY,XDataFrame-method
###   coerce,matrix,XDataFrame-method coerce,list,XDataFrame-method
###   coerce,integer,XDataFrame-method coerce,data.frame,XDataFrame-method
###   coerce,XDataFrame,data.frame-method as.list,XDataFrame-method cbind
###   cbind,XDataFrame-method rbind rbind,XDataFrame-method
###   split,XDataFrame-method show,XDataFrame-method
###   is.array,XDataFrame-method
### Keywords: classes methods

### ** Examples

  score <- c(1L, 3L, NA)
  counts <- c(10L, 2L, NA)
  row.names <- c("one", "two", "three")
  
  xdf <- XDataFrame(score) # single column
  xdf[["score"]]
  xdf <- XDataFrame(score, row.names = row.names) #with row names
  rownames(xdf)
  
  xdf <- XDataFrame(vals = score) # explicit naming
  xdf[["vals"]]
  
  # a data.frame
  sw <- XDataFrame(swiss)
  as.data.frame(sw) # swiss, without row names
  # now with row names
  sw <- XDataFrame(swiss, row.names = rownames(swiss))
  as.data.frame(sw) # swiss

  # subsetting
    
  sw[] # identity subset
  sw[,] # same

  sw[NULL] # no columns
  sw[,NULL] # no columns
  sw[NULL,] # no rows

  ## select columns
  sw[1:3]
  sw[,1:3] # same as above
  sw[,"Fertility"]
  sw[,c(TRUE, FALSE, FALSE, FALSE, FALSE, FALSE)]

  ## select rows and columns
  sw[4:5, 1:3]
  
  sw[1] # one-column XDataFrame
  ## the same
  sw[, 1, drop = FALSE]
  sw[, 1] # a (unnamed) vector
  sw[[1]] # the same
  sw[["Fertility"]]

  sw[["Fert"]] # should return 'NULL'
  
  sw[1,] # a one-row XDataFrame
  sw[1,, drop=TRUE] # a list

  ## duplicate row, unique row names are created
  sw[c(1, 1:2),]

  ## indexing by row names  
  sw["Courtelary",]
  subsw <- sw[1:5,1:4]
  subsw["C",] # partially matches

  ## row and column names
  cn <- paste("X", seq_len(ncol(swiss)), sep = ".")
  colnames(sw) <- cn
  colnames(sw)
  rn <- seq(nrow(sw))
  rownames(sw) <- rn
  rownames(sw)

  ## column replacement

  xdf[["counts"]] <- counts
  xdf[["counts"]]
  xdf[[3]] <- score
  xdf[["X"]]
  xdf[[3]] <- NULL # deletion

  ## split

  sw <- XDataFrame(swiss)
  swsplit <- split(sw, sw[["Education"]])
  
  ## rbind

  do.call(rbind, as.list(swsplit))

  ## cbind

  cbind(XDataFrame(score), XDataFrame(counts))



