### Name: convert
### Title: Efficienctly convert strings of characters into integer codes
### Aliases: convert
### Keywords: misc

### ** Examples

###
# Toy Genetics Example
##
# 'c' = 'homozygote common allele'
# 'h' = 'heterozygone'
# 'r' = 'homozygote rare allele'
marker.data <- c( m1='cchchrcr', m2='chccccrr')
marker.data

convert(marker.data, c('c','h','r'))

###
# simple test example
###
source <- c(one='abcabcabc', two='abc','ggg',buckle='aaa',my='bbb',
            'shoe  '='bgb  ')
levels <- c('a','b','c','d')

convert(source,levels)
convert(source,levels,aslist=TRUE)
convert(source,levels,byrow=TRUE)

###
# compare efficiency with equivalent code using 'factor'
###
## Not run: 
##D makestr <- function(n)
##D   paste(sample(letters, size=n, replace=T), sep='', collapse='')
##D 
##D timeit <- function( expr )
##D   {
##D     start <- Sys.time()
##D     expr
##D     end <- Sys.time()
##D     return( as.numeric(end-start ))
##D   }
##D 
##D # Step 1: create a large set of character strings
##D x <- unlist(lapply(1:100000, function(x) makestr(1000)))
##D 
##D # Step 2: Time convert  (~17 sec on Intel Xeon 3.0 GHz, 32 GB RAM)
##D newtime <- timeit( yn <- convert2(x, letters) )
##D newtime
##D 
##D # old method  (~4.7 min on Intex Xeon 3.0 GHz, 32 GB RAM)
##D oldmethod <- function(x)
##D   {
##D     yo <- factor(unlist(strsplit(x, split='')),levels=letters)
##D     attr(y1,'dim') <- c(nchar(x[1]), length(x))
##D     class(y1) <- 'matrix'
##D   }
##D 
##D oldtime <- timeit( oldmethod(x) )
##D oldtime
##D 
##D # time difference
##D oldtime - newtime
## End(Not run)




