### Name: GetStabilityOverlap
### Title: Stability measures for gene rankings
### Aliases: GetStabilityOverlap
### Keywords: univar

### ** Examples

 ## Load toy gene expression data
data(toydata)
### class labels
yy <- toydata[1,]
### gene expression
xx <- toydata[-1,]
### get ranking 
ordT <- RankingTstat(xx, yy, type="unpaired")
### Generate Leave-One-Out
loo <- GenerateFoldMatrix(xx, yy, k=1)
### Repeat Ranking with t-statistic
loor_ordT <- GetRepeatRanking(ordT, loo)
### assess stability
stab_ov_ordT <- GetStabilityOverlap(loor_ordT, decay="linear")
### for a short summary
summary(stab_ov_ordT)
### for a graphical display
plot(stab_ov_ordT )



