### Name: GetRepeatRanking
### Title: Repeat the ranking procedure for altered data sets
### Aliases: GetRepeatRanking
### Keywords: univar

### ** Examples

 ## Load toy gene expression data
data(toydata)
### class labels
yy <- toydata[1,]
### gene expression
xx <- toydata[-1,]
### Get ranking for the original data set, with the ordinary t-statistic
ordT <- RankingTstat(xx, yy, type="unpaired")
### Generate the leave-one-out / exchange-one-label matrix
loo <- GenerateFoldMatrix(xx, yy, k=1)
### Repeat the ranking with the t-statistic, using the leave-one-out scheme
loor_ordT <- GetRepeatRanking(ordT, loo)
### .. or the label exchange scheme
ex1r_ordT <- GetRepeatRanking(ordT, loo, scheme = "Labelexchange")
### Generate the bootstrap matrix
boot <- GenerateBootMatrix(xx, yy, maxties=3, minclassize=5, repl=30)
### Repeat ranking with the t-statistic for bootstrap replicates
boot_ordT <- GetRepeatRanking(ordT, boot)
### Repeat the ranking procedure for an altered data set with added noise
noise_ordT <- GetRepeatRanking(ordT, varlist=list(genewise=TRUE, factor=1/10))



