### Name: GeneSetCollection-class
### Title: Class "GeneSetCollection"
### Aliases: GeneSetCollection-class updateObject,GeneSetCollection-method
###   names,GeneSetCollection-method geneIds,GeneSetCollection-method
###   geneIds<-,GeneSetCollection,list-method
###   Logic,character,GeneSetCollection-method
###   Logic,GeneSet,GeneSetCollection-method
###   |,GeneSetCollection,GeneSetCollection-method
###   |,GeneSetCollection,ANY-method |,ANY,GeneSetCollection-method
###   &,GeneSetCollection,GeneSetCollection-method
###   &,GeneSetCollection,ANY-method &,ANY,GeneSetCollection-method
###   intersect,ANY,GeneSetCollection-method
###   intersect,GeneSetCollection,ANY-method
###   setdiff,ANY,GeneSetCollection-method
###   setdiff,GeneSetCollection,ANY-method toGmt,GeneSetCollection-method
###   union,ANY,GeneSetCollection-method union,GeneSetCollection,ANY-method
###   [<-,GeneSetCollection,ANY,ANY,ANY-method
###   [<-,GeneSetCollection,ANY,ANY,GeneSet-method
###   [<-,GeneSetCollection,character,ANY,GeneSet-method
###   [,GeneSetCollection,logical,ANY-method
###   [,GeneSetCollection,numeric,ANY-method
###   [,GeneSetCollection,character,ANY-method
###   [[,GeneSetCollection,character-method
###   [[<-,GeneSetCollection,ANY,ANY,ANY-method
###   [[<-,GeneSetCollection,numeric,ANY,GeneSet-method
###   [[<-,GeneSetCollection,character,ANY,GeneSet-method
###   show,GeneSetCollection-method
### Keywords: classes

### ** Examples

gs1 <- GeneSet(setName="set1", setIdentifier="101")
gs2 <- GeneSet(setName="set2", setIdentifier="102")

## construct from indivdiual elements...
gsc <- GeneSetCollection(gs1, gs2)
## or from a list
gsc <- GeneSetCollection(list(gs1, gs2))

## 'names' are the setNames
names(gsc)

## a collection of a single gene set
gsc["set1"]
## a gene set
gsc[["set1"]]

## set names must be unique
try(GeneSetCollection(gs1, gs1))
try(gsc[c("set1", "set1")])



