### Name: cisSnpTests
### Title: perform tests for eQTL cis to specified genes
### Aliases: cisSnpTests
### Keywords: models

### ** Examples

library(GSEABase)
# two genes on chr 20
gs1 = GeneSet(c("CPNE1", "ADA"), geneIdType = SymbolIdentifier())
gs2 = gs1
organism(gs2) = "Homo sapiens"
geneIdType(gs2) = AnnotationIdentifier("illuminaHumanv1.db")
if (!exists("hmceuB36.2021")) data(hmceuB36.2021)
cc = cisSnpTests(gs2~male, hmceuB36.2021, radius=1e5)
lapply(cc, function(x) length(p.value(x@.Data[[1]])))
cc = cisSnpTests(gs2~male, hmceuB36.2021, radius=1e6)
lapply(cc, function(x) length(p.value(x@.Data[[1]])))



