### Name: morphology
### Title: Perform morphological operations on images
### Aliases: dilate closing erode opening makeBrush


### ** Examples
      
    x = readImage(system.file("images", "shapes.png", package="EBImage"))
    if (interactive()) display(x)
    kern = makeBrush(5, shape='diamond')
    if (interactive()) display(kern, title='Structuring element')
    if (interactive()) display(erode(x, kern), title='Erosion of x')
    if (interactive()) display(dilate(x, kern), title='Dilatation of x')

    ## makeBrush 
    x = makeBrush(100, shape='diamond')
    if (interactive()) display(x, title="makeBrush(100, shape='diamond')")
    x = makeBrush(100, shape='disc', step=FALSE)
    if (interactive()) display(x, title="makeBrush(100, shape='disc', step=FALSE)")



