### Name: getFeatures
### Title: Extract feature extraction from image objects
### Aliases: getFeatures
### Keywords: manip

### ** Examples

  x = readImage(system.file('images', 'nuclei.tif', package='EBImage'))
  x = x[,,1]
  if (interactive()) display(x)

  ## computes object mask
  y = thresh(x, 10, 10, 0.05)
  y = opening(y, makeBrush(5, shape='disc'))
  mask = bwlabel(y)
  if (interactive()) display(mask, title='Cell nuclei')

  ## features
  ftrs = getFeatures(mask, x)[[1]]
  print(ftrs[1:5,])

  ## paint nuclei with an eccentricity higher than 0.85
  maskb = mask
  id = which(ftrs[,'m.ecc']<0.85)
  maskb[!is.na(match(maskb, id))] = 0

  img = paintObjects(maskb, channel(x, 'rgb'), col='red')
  if (interactive()) display(img, title='Nuclei with high eccentricity')



