### Name: moments
### Title: Image moments and moment invariants
### Aliases: moments cmoments smoments rmoments


### ** Examples

  ## load cell nucleus images
  x = readImage(system.file('images', 'nuclei.tif', package='EBImage'))
  if (interactive()) display(x)

  ## computes object mask
  y = thresh(x, 10, 10, 0.05)
  y = opening(y, makeBrush(5, shape='disc'))
  mask = fillHull(bwlabel(y))
  if (interactive()) display(mask, title='Cell nuclei')

  ## moments
  m = moments(mask, x)
  mc = do.call(rbind, m)
  print(mc[1:5,])
  cat('Mean nucleus size is', mean(mc[,'m.pxs']), '\n')
  cat('Mean nucleus eccentricity is', mean(mc[,'m.ecc']), '\n')

  ## paint nuclei with an eccentricity higher than 0.85
  maskb = mask
  for (i in 1:dim(mask)[3]) {
    id = which(m[[i]][,'m.ecc']<0.85)
    z = maskb[,,i]
    z[!is.na(match(z, id))] = 0
    maskb[,,i] = z
  } 
  img = paintObjects(maskb, channel(x, 'rgb'), col=c(NA, 'red'), opac=c(0,0.7))
  if (interactive()) display(img, title='Nuclei with high eccentricity')



