### Name: findAdducts-methods
### Title: Calculate Adducts and Annotate LC/ESI-MS Spectra
### Aliases: findAdducts findAdducts,xsAnnotate-method
### Keywords: methods

### ** Examples

 library(CAMERA)
 file <- system.file('mzdata/MM14.mzdata', package = "CAMERA")
 xs   <- xcmsSet(file, method="centWave", ppm=30, peakwidth=c(5,10))
 an   <- xsAnnotate(xs)
 an   <- groupFWHM(an)
# an <- groupCorr(an,xs) # optional but very recommended step

 an <- findIsotopes(an)  # optional but recommended.
 an <- findAdducts(an,polarity="positive")
 peaklist <- getPeaklist(an) # get the annotated peak list



