### Name: basecontent
### Title: Obtain the ATCG content of a gene
### Aliases: basecontent countbases
### Keywords: manip

### ** Examples

 v<-c("AAACT", "GGGTT", "ggAtT")

 ## Do not use these functions anymore:
 if (interactive()) {
   basecontent(v)
   countbases(v)
 }

 ## But use more efficient alphabetFrequency() instead:
 v <- DNAStringSet(v)
 alphabetFrequency(v, baseOnly=TRUE)

 ## Comparing efficiencies:
 if (interactive()) {
   library(hgu95av2probe)
   system.time(y1 <- countbases(hgu95av2probe$sequence))
   x <- DNAStringSet(hgu95av2probe$sequence)
   system.time(y2 <- alphabetFrequency(x, baseOnly=TRUE))
 }



