### Name: XStringSet-io
### Title: Read/write an XStringSet or XStringViews object from/to a file
### Aliases: read.XStringViews read.BStringSet read.DNAStringSet
###   read.RNAStringSet read.AAStringSet write.XStringSet
###   write.XStringViews fastq.geometry FASTArecordsToCharacter
###   CharacterToFASTArecords FASTArecordsToXStringViews
###   XStringSetToFASTArecords read.BStringViews write.BStringViews
###   FASTArecordsToBStringViews
### Keywords: utilities manip

### ** Examples

  ## ---------------------------------------------------------------------
  ## A. READ/WRITE FASTA FILES
  ## ---------------------------------------------------------------------
  file <- system.file("extdata", "someORF.fa", package="Biostrings")
  x <- read.DNAStringSet(file, "fasta")
  x
  write.XStringSet(x, format="fasta")  # writes to the console

  ## ---------------------------------------------------------------------
  ## B. READ FASTQ FILES
  ## ---------------------------------------------------------------------
  file <- system.file("extdata", "s_1_sequence.txt", package="Biostrings")
  fastq.geometry(file)
  read.DNAStringSet(file, "fastq")  # only the FASTQ sequences are returned
                                    # (identifiers and qualities are dropped)

  ## ---------------------------------------------------------------------
  ## C. SOME RELATED HELPER FUNCTIONS
  ## ---------------------------------------------------------------------
  ## Converting 'x'...
  ## ... to a list of FASTA records (as one returned by the "readFASTA" function)
  x1 <- XStringSetToFASTArecords(x)
  ## ... to a named character vector
  x2 <- FASTArecordsToCharacter(x1) # same as 'as.character(x)'



