### Name: contrastMatrix
### Title: Class to Contain the Contrast Matrix that Used for Linear
###   Regression
### Aliases: contrastMatrix-class contrastMatrix class:contrastMatrix
###   getCompare1,contrastMatrix-method getCompare2,contrastMatrix-method
###   getContrast,contrastMatrix-method
###   getInteraction,contrastMatrix-method getLevel,contrastMatrix-method
###   initialize,contrastMatrix-method show,contrastMatrix-method
### Keywords: classes

### ** Examples

data(eSetExample)
## One-way Anova
(design1<- new("designMatrix", target=pData(eSetExample), covariates = "Treatment"))
(contrast1<- new("contrastMatrix", design.matrix = design1, 
    compare1 = "Treated", compare2 = "Control"))
        
## Randomized block design
(design2<- new("designMatrix", target=pData(eSetExample), 
   covariates = c("Treatment", "Group")))
(contrast2<- new("contrastMatrix", design.matrix = design2, 
    compare1 = "Treated", compare2 = "Control"))

## Interaction design
(design3<- new("designMatrix", target=pData(eSetExample), 
   covariates = c("Treatment", "Group"), intIndex=c(1,2)))
# Test for interaction:
(contrast.int<- new("contrastMatrix", design.matrix = design3,
    interaction=TRUE))
# Compare Treated vs Control among group A
(contrast.a<- new("contrastMatrix", design.matrix = design3, 
    compare1 = "Treated", compare2 = "Control", level="A"))



