###################################################
### chunk number 1: queryAE
###################################################
library("ArrayExpress")
sets = queryAE(keywords = "pneumonia", species = "homo+sapiens")


###################################################
### chunk number 2: ArrayExpress-raw
###################################################
rawset = ArrayExpress("E-MEXP-1422")


###################################################
### chunk number 3: ArrayExpress-columnsneeded
###################################################
eset = try(ArrayExpress("E-DKFZ-1"))


###################################################
### chunk number 4: ArrayExpress-withcolumns
###################################################
eset = ArrayExpress("E-DKFZ-1",
  rawcol=list(R="Software Unknown:Foreground red",
    G="Software Unknown:Foreground green",
    Rb="Software Unknown:Background red" ,
    Gb="Software Unknown:Background green"))


###################################################
### chunk number 5: getAE-full
###################################################
mexp1422 = getAE("E-MEXP-1422", type = "full")


###################################################
### chunk number 6: magetab2bioc-full
###################################################
rawset= magetab2bioc(files = mexp1422)


###################################################
### chunk number 7: getcolproc
###################################################
cn = getcolproc(mexp1422)
show(cn)


###################################################
### chunk number 8: procset
###################################################
proset = procset(mexp1422, cn[2])


