### Name: TilingCelFiles2Probesets
### Title: Background correction and RNA normalization for CEL files from
###   an Affymetrix tiling array.
### Aliases: TilingCelFiles2Probesets
### Keywords: data

### ** Examples

## Note that executing the following example requires .bpmap and .cel files in the working directory.
## If these files do not, the program will not execute.

## Creates a sample interval of the first 1MB of chromosome 1-3.
## This function will return a single value for each interval.
iCHR <- c("chr1", "chr2", "chr3")
iSTART <- rep(1, 3)
iEND <- iSTART + 1e+06

## Get the file names in the current working directory.
CEL_NAMES <- dir(pattern=".CEL|.cel");
BPMAP     <- dir(pattern=".bpmap");

## If files are found in the current working directory ... start the analysis!!
if( (NROW(CEL_NAMES) > 0) & (NROW(BPMAP) > 0) ) {
  TilingCelFiles2Probesets(CEL_NAMES, BPMAP, outfilename="NormalizedData.tsv", iID=NULL, iCHR=iCHR, iSTART=iSTART, iEND=iEND);
}



