### Name: AnalyzeTilingCelFiles
### Title: Background correction and RNA normalization for CEL files from
###   an Affymetrix tiling array.
### Aliases: AnalyzeTilingCelFiles
### Keywords: data

### ** Examples

## Note that executing the following example requires .bpmap and .cel files in the working directory.
## If these files do not, the program will not execute.

## Get the file names in the current working directory.
CEL_NAMES <- dir(pattern=".CEL|.cel");
BPMAP     <- dir(pattern=".bpmap");

## If files are found in the current working directory ... start the analysis!!
if( (NROW(CEL_NAMES) > 0) & (NROW(BPMAP) > 0) ) {
  AnalyzeTilingCelFiles(CEL_NAMES, BPMAP, outfilename="NormalizedData.tsv");
}



