### Name: calculatePathwayStatistics
### Title: Calculate the NTk and NEk statistics
### Aliases: calculate.NTk calculate.NEk
### Keywords: array htest

### ** Examples

## Load in filtered, expression data
data(MuscleExample)

## Prepare the pathways to analyze
probeID <- rownames(tab)
gsList <- selectGeneSets(G, probeID, 20, 500)

## Calculate NTk and weighted NEk for each gene set
## * Use a higher nsim (e.g., 2500) value for more reproducible results
nsim <- 1000
ngroups <- 2
verbose <- TRUE
weightType <- "constant"
methodNames <- c("NTk", "NEk")
npath <- 25
allpathways <- FALSE
annotpkg <- "hgu133a.db"

res.NTk <- calculate.NTk(tab, phenotype, gsList, nsim, ngroups, verbose)
res.NEk <- calculate.NEk(tab, phenotype, gsList, nsim, weightType,
                         ngroups, verbose)

## Summarize results
res.pathways <- rankPathways(res.NTk, res.NEk, G, tab, phenotype,
                             gsList, ngroups, methodNames, npath, allpathways)
print(res.pathways)

## Get more information about the probe sets' means and other statistics
## for the top pathway in res.pathways
statList <- calcTStatFast(tab, phenotype, ngroups)
gpsList <-
  getPathwayStatistics(tab, phenotype, G, res.pathways$IndexG,
                       ngroups, statList, FALSE, annotpkg)
print(gpsList[[1]])

## Write table of top-ranked pathways and their associated probe sets to
## HTML files
parameterList <-
  list(nprobes = nrow(tab), nsamples = ncol(tab),
       phenotype = phenotype, ngroups = ngroups,
       minNPS = 20, maxNPS = 500, ngs = res.NTk$ngs,
       nsim.NTk = res.NTk$nsim, nsim.NEk = res.NEk$nsim,
       weightType = weightType,
       annotpkg = annotpkg, npath = npath, allpathways = allpathways)

writeSP(res.pathways, gpsList, parameterList, tempdir(), "sigPathway_cPS",
        "TopPathwaysTable.html")




