### Name: gateSet-class
### Title: 'gateSet': a class for subsetting flow-cytometry data by
###   defining multiple regions in two-dimesional projections of the data
### Aliases: gateSet-class gateSet length,gateSet-method
###   show,gateSet-method names,gateSet-method names<-,gateSet-method
###   applyGate [,gateSet,ANY,missing,missing-method
###   [[,gateSet,ANY,missing-method appendGates 'appendGates,
###   gateSet_method' applyGate,matrix,gateSet-method
### Keywords: classes

### ** Examples

sampdat <- readFCS(system.file("extdata", "fas-Bcl2-plate323-04-04.A01",
                               package="prada"))
g1 <- new("gate", name="G1", gateFun=function(x)x[,"FSC-H"]<500, logic="&",
          colnames="FSC-H")
g2 <- new("gate", name="G2", gateFun=function(x)x[,"SSC-H"]>800, logic="&",
          colnames="SSC-H")
g3 <- new("gate", name="G3", gateFun=function(x)x[,"FL1-H"]>800, logic="&",
          colnames="FL1-H")
gs <- new("gateSet", name="Set1", glist=list(G1=g1, G2=g2))
length(gs)
gs[[1]]
gs[1]
gsnames <- names(gs)
names(gs) <- gsnames
applyGate(sampdat, gs)
applyGate(exprs(sampdat), gs)
gate(sampdat) <- gs
applyGate(sampdat, 1)
applyGate(sampdat, "G1")
applyGate(sampdat, TRUE)
appendGates(sampdat, g3)




