mt.plot               package:multtest               R Documentation

_P_l_o_t_t_i_n_g _r_e_s_u_l_t_s _f_r_o_m _m_u_l_t_i_p_l_e _t_e_s_t_i_n_g _p_r_o_c_e_d_u_r_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     This function produces a number of graphical summaries for the
     results of multiple testing procedures and their corresponding
     adjusted p-values.

_U_s_a_g_e:

     mt.plot(adjp, teststat, plottype="rvsa", logscale=FALSE, alpha=seq(0, 1, length = 100), proc, leg=c(0, 0), ...)

_A_r_g_u_m_e_n_t_s:

    adjp: A matrix of adjusted _p_-values, with rows corresponding to
          hypotheses (genes) and columns to multiple testing
          procedures. This matrix could be obtained from the functions
          'mt.maxT', 'mt.minP', or 'mt.rawp2adjp'.

teststat: A vector of test statistics for each of the hypotheses. This
          vector could be obtained from the functions 'mt.teststat',
          'mt.maxT', or 'mt.minP'.

plottype: A character string specifying the type of graphical summary
          for the results of the multiple testing procedures. 
           If 'plottype="rvsa"', the number of rejected hypotheses is
          plotted against the nominal Type I error rate for each of the
          procedures given in 'proc'.
           If 'plottype="pvsr"', the ordered adjusted _p_-values are
          plotted for each of the procedures given in 'proc'. This can
          be viewed as a plot of the Type I error rate against the
          number of rejected hypotheses. 
           If 'plottype="pvst"', the adjusted _p_-values are plotted
          against the test statistics for each of the procedures given
          in 'proc'. 
           If 'plottype="pvsi"', the adjusted _p_-values are plotted
          for each of the procedures given in 'proc' using the original
          data order.  

logscale: A logical variable for the 'pvst' and 'pvsi' plots. If
          'logscale' is 'TRUE', the negative decimal logarithms of the
          adjusted _p_-values are plotted against the test statistics
          or gene indices. If 'logscale' is 'FALSE', the adjusted
          _p_-values are plotted against the test statistics or gene
          indices.

   alpha: A vector of nominal Type I error rates for the 'rvsa' plot.

    proc: A vector of character strings containing the names of the
          multiple testing procedures, to be used in the legend.

     ...: Graphical parameters such as 'col', 'lty', 'pch', and 'lwd'
          may also be supplied as arguments to the function (see
          'par').

     leg: A vector of coordinates for the legend.

_A_u_t_h_o_r(_s):

     Sandrine Dudoit,  <URL: http://www.stat.berkeley.edu/~sandrine>, 
      Yongchao Ge, yongchao.ge@mssm.edu.

_R_e_f_e_r_e_n_c_e_s:

     S. Dudoit, J. P. Shaffer, and J. C. Boldrick (Submitted). Multiple
     hypothesis testing in microarray experiments.

     Y. Ge, S. Dudoit, and T. P. Speed. Resampling-based multiple
     testing for microarray data hypothesis, Technical Report #633 of
     UCB Stat. <URL: http://www.stat.berkeley.edu/~gyc>  

_S_e_e _A_l_s_o:

     'mt.maxT', 'mt.minP', 'mt.rawp2adjp',  'mt.reject', 'mt.teststat',
     'golub'.

_E_x_a_m_p_l_e_s:

     # Gene expression data from Golub et al. (1999)
     # To reduce computation time and for illustrative purposes, we condider only
     # the first 100 genes and use the default of B=10,000 permutations.
     # In general, one would need a much larger number of permutations
     # for microarray data.

     data(golub)
     smallgd<-golub[1:100,] 
     classlabel<-golub.cl

     # Permutation unadjusted p-values and adjusted p-values for maxT procedure
     res1<-mt.maxT(smallgd,classlabel)
     rawp<-res1$rawp[order(res1$index)]
     teststat<-res1$teststat[order(res1$index)]

     # Permutation adjusted p-values for simple multiple testing procedures
     procs<-c("Bonferroni","Holm","Hochberg","SidakSS","SidakSD","BH","BY")
     res2<-mt.rawp2adjp(rawp,procs)

     # Plot results from all multiple testing procedures
     allp<-cbind(res2$adjp[order(res2$index),],res1$adjp[order(res1$index)])
     dimnames(allp)[[2]][9]<-"maxT"
     procs<-dimnames(allp)[[2]]
     procs[7:9]<-c("maxT","BH","BY")
     allp<-allp[,procs]

     cols<-c(1:4,"orange","brown","purple",5:6)
     ltypes<-c(3,rep(1,6),rep(2,2))

     # Ordered adjusted p-values
     mt.plot(allp,teststat,plottype="pvsr",proc=procs,leg=c(80,0.4),lty=ltypes,col=cols,lwd=2)

     # Adjusted p-values in original data order
     mt.plot(allp,teststat,plottype="pvsi",proc=procs,leg=c(80,0.4),lty=ltypes,col=cols,lwd=2)

     # Number of rejected hypotheses vs. level of the test
     mt.plot(allp,teststat,plottype="rvsa",proc=procs,leg=c(0.05,100),lty=ltypes,col=cols,lwd=2)

     # Adjusted p-values vs. test statistics
     mt.plot(allp,teststat,plottype="pvst",logscale=TRUE,proc=procs,leg=c(0,4),pch=ltypes,col=cols)

