### Name: boxplot
### Title: Boxplots for cDNA microarray spot statistics
### Aliases: boxplot,marrayRaw-method boxplot,marrayNorm-method
### Keywords: hplot

### ** Examples


# To see the demo type demo(marrayPlots)

# Examples use swirl dataset, for description type ? swirl
data(swirl)

# Boxplots of pre-normalization log-ratios M for each of the 16 
# print-tip-groups for the Swirl 93 array. 
# - Default arguments
boxplot(swirl[,3])  

# All spots 
boxplot(swirl[,3], xvar=NULL, col="green")  

# Boxplots of pre-normalization red foreground intensities for each grid row
# for the Swirl 81 array. 
boxplot(swirl[,1], xvar="maGridRow", yvar = "maRf", main = "Swirl array 81: pre-normalization red foreground intensity") 

# Boxplots of pre-normalization log-ratios for each array in swirl
boxplot(swirl, main="Swirl arrays: pre-normalization log-ratios")



