###################################################
### chunk number 1: options
###################################################
options(width=60)


###################################################
### chunk number 2: preliminaries
###################################################
library(ShortRead)


###################################################
### chunk number 3: SolexaPath-root
###################################################
exptPath <- system.file("extdata", package="ShortRead")


###################################################
### chunk number 4: SolexaPat
###################################################
sp <- SolexaPath(exptPath)
sp


###################################################
### chunk number 5: firecrest
###################################################
imageAnalysisPath(sp)
analysisPath(sp)


###################################################
### chunk number 6: readAligned-simple
###################################################
aln <- readAligned(sp, "s_2_export.txt")
aln


###################################################
### chunk number 7: aln-sread-quality
###################################################
sread(aln)
quality(aln)


###################################################
### chunk number 8: chromosomes
###################################################
whichStrand <- strand(aln)
class(whichStrand)
levels(whichStrand)
table(whichStrand)


###################################################
### chunk number 9: alignData
###################################################
alignData(aln)


###################################################
### chunk number 10: varMetadata
###################################################
varMetadata(alignData(aln))


###################################################
### chunk number 11: aln-okreads
###################################################
mapped <- !is.na(position(aln))
filtered <- alignData(aln)[["filtering"]] =="Y"
sum(!mapped) / length(aln)
sum(filtered) / length(aln)


###################################################
### chunk number 12: aln-failed
###################################################
failedAlign <- aln[filtered & !mapped]
failedAlign


###################################################
### chunk number 13: sread-filter-fail-subset
###################################################
failedReads <- sread(aln)[filtered & !mapped]


###################################################
### chunk number 14: qa
###################################################
qaSummary <- qa(sp)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## save(qaSummary, file="/path/to/file.rda")


###################################################
### chunk number 16:  eval=FALSE
###################################################
## library(Rmpi)
## mpi.spawn.Rslaves(nsl=8)
## qaSummary <- qa(sp)
## mpi.close.Rslaves()


###################################################
### chunk number 17: qa-elements
###################################################
qaSummary


###################################################
### chunk number 18: qa-readCounts
###################################################
qaSummary[["readCounts"]]
qaSummary[["baseCalls"]]


###################################################
### chunk number 19: report eval=FALSE
###################################################
## report(qaSummary, dest="/path/to/qa_report.pdf")


###################################################
### chunk number 20: export
###################################################
pattern <- "s_2_export.txt"
fl <- file.path(analysisPath(sp), pattern)
strsplit(readLines(fl, n=1), "\t")
length(readLines(fl))


###################################################
### chunk number 21: colClasses
###################################################
colClasses <- rep(list(NULL), 21)
colClasses[9:10] <- c("DNAString", "BString")
names(colClasses)[9:10] <- c("read", "quality")


###################################################
### chunk number 22: readXStringColumns
###################################################
cols <- readXStringColumns(analysisPath(sp), pattern, colClasses)
cols


###################################################
### chunk number 23: size
###################################################
object.size(cols$read)
object.size(as.character(cols$read))


###################################################
### chunk number 24: fastq-format
###################################################
fqpattern <- "s_1_sequence.txt"
fl <- file.path(analysisPath(sp), fqpattern)
readLines(fl, 4)


###################################################
### chunk number 25: readFastq
###################################################
fq <- readFastq(sp, fqpattern)
fq


###################################################
### chunk number 26: ShortReadQ
###################################################
reads <- sread(fq)
qualities <- quality(fq)
class(qualities)
id(fq)


###################################################
### chunk number 27: ShortReadQ-subset
###################################################
fq[1:5]


###################################################
### chunk number 28: intensity-files
###################################################
intFile <- list.files(imageAnalysisPath(sp), "s_1_0001_int.txt", full=TRUE)
strsplit(readLines(intFile, 1), "\t")[[1]][1:6]
intDf <- read.table(intFile)
dim(intDf)


###################################################
### chunk number 29: intensities-cycle-2
###################################################
c2 <- intDf[,2*4 + 1:4]
colnames(c2) <- c("A", "C", "G", "T")
print(splom(c2, pch=".", cex=3))


###################################################
### chunk number 30: tables
###################################################
tbls <- tables(aln)
names(tbls)
tbls$top[1:5]
head(tbls$distribution)


###################################################
### chunk number 31: srdistance
###################################################
dist <- srdistance(sread(aln), names(tbls$top)[1])[[1]]
table(dist)[1:10]


###################################################
### chunk number 32: aln-not-near
###################################################
alnSubset <- aln[dist>4]


###################################################
### chunk number 33: polya
###################################################
countA <- alphabetFrequency(sread(aln))[,"A"] 
alnNoPolyA <- aln[countA < 30]


###################################################
### chunk number 34: readSeq
###################################################
seqFls <- list.files(baseCallPath(sp), "_seq.txt", full=TRUE)
strsplit(readLines(seqFls[[1]], 1), "\t")
colClasses <- c(rep(list(NULL), 4), "DNAString")
reads <- readXStringColumns(baseCallPath(sp), "s_1_0001_seq.txt",
                            colClasses=colClasses)


###################################################
### chunk number 35: readSeq-all
###################################################
reads <- readXStringColumns(baseCallPath(sp), "s_1_.*_seq.txt",
                            colClasses=colClasses)


###################################################
### chunk number 36: calcInt-demo
###################################################
calcInt <- function(filename, cycle, verbose=FALSE)
{
    if (verbose)
        cat("calcInt", filename, cycle, "\n")
    c12 <- read.table(filename)[,cycle*4 + 1:4]
    colnames(c12) <- c("A", "C", "G", "T")
    colMeans(c12)
}


###################################################
### chunk number 37: calcInt-sapply
###################################################
intFls <- list.files(imageAnalysisPath(sp), ".*_int.txt", full=TRUE)
lres <- lapply(intFls, calcInt, cycle=12)


###################################################
### chunk number 38: srapply-simple
###################################################
srres <- srapply(intFls, calcInt, cycle=12)
identical(lres, srres)


###################################################
### chunk number 39: srapply-mpi eval=FALSE
###################################################
## library(Rmpi)
## mpi.spawn.Rslaves(nsl=16)
## srres <- srapply(intFls, calcInt, cycle=12)
## mpi.close.Rslaves()


