### Name: pileup
### Title: Calculate a pile-up representation of short-read mappings
### Aliases: pileup


### ** Examples
## Not run:  
##D 
##D Example 1: Assuming that 'lane' is a AlignedRead object containing aligned reads froma
##D Solexa lane, you may get a pile-up representation of chromosome 13 as follows
##D 
##D chr13length <- 114142980   # the length of human chromosme 13
##D pu <- pileup( position(lane)[chromosome(lane)=="13"], width(lane), chr13length )
##D 
##D Example 2: Even though the width of the reads (as repored by this-is-escaped-codenormal-bracket24bracket-normal) is only 24,
##D these 24 bp are just one end of a longer fragment. Assuming that all fragments have been
##D sonicated to about the same length, say 150 bp, we may get a better pile-up representation by:
##D 
##D pu2 <- pileup( position(lane)[chromosome(lane)=="13"], 150, chr13length,
##D strand(lane)[chromosome(lane)=="13"], width(lane) )
##D 
## End(Not run)


