###################################################
### chunk number 1: 
###################################################
library("SAGx")
library("multtest")
data(golub)
set.seed(849867)
samroc.res <- samrocN(data = golub, formula = ~as.factor(golub.cl))
show(samroc.res)


###################################################
### chunk number 2: dummyex3 eval=FALSE
###################################################
## plot(samroc.res)


###################################################
### chunk number 3: 
###################################################
par(bg = "cornsilk")
plot(samroc.res)


###################################################
### chunk number 4: 
###################################################
par(bg = "cornsilk")
hist(samroc.res@pvalues, xlab = "p-value", main ="", col = 'orange', freq  = F)
print(abline(samroc.res@p0,0, col = 'red'))


###################################################
### chunk number 5: 
###################################################
par(bg = "cornsilk")
fdrs <- pava.fdr(ps = samroc.res@pvalues)
plot(samroc.res@pvalues, fdrs$pava.local.fdr, type = 'n', xlab = "p-value", ylab = "False Discovery Rate (FDR)")
lines(lowess(samroc.res@pvalues, fdrs$pava.local.fdr), col = 'red')
lines(lowess(samroc.res@pvalues, fdrs$pava.fdr), col = 'blue')
legend(0.1,0.9,pch=NULL,col=c("red","blue"),c("pava local FDR","pava FDR"),lty = 1)


###################################################
### chunk number 6: 
###################################################
library("hu6800.db")
kegg <- as.list(hu6800PATH2PROBE)
probeset <- golub.gnames[,3]
GSEA.mean.t(samroc = samroc.res, probeset = probeset, pway = kegg[1],
type = "original", two.side = FALSE)



