### Name: compareHits
### Title: Searching for common hits between different scoring methods
### Aliases: compareHits
### Keywords: arith

### ** Examples

data(scoredDataset1, package="RNAither")
data(pValVec1, package="RNAither")

data(scoredDataset2, package="RNAither")
data(pValVec2, package="RNAither")

##for details on the generation of pValVec and scoredDataset,
##see the examples of the functions Ttest and MannWhitney linked above.

scoredHits1 <- hitselectionPval(scoredDataset1, pValVec1, "SigIntensity", "Hits1", 0.05, 
"GeneName", "pvalue_testfile1.txt")
scoredHits2 <- hitselectionPval(scoredDataset2, pValVec2, "SigIntensity", "Hits2", 0.05, 
"GeneName", "pvalue_testfile2.txt")

hitVector1 <- scoredHits1[[2]]
hitVector2 <- scoredHits2[[2]]

common_hits <- compareHits(hitVector1, hitVector2, names(hitVector1), names(hitVector2))



