### Name: GeneColorSet-class
### Title: Class "GeneColorSet"
### Aliases: GeneColorSet-class |,GeneColorSet,GeneColorSet-method
###   |,GeneColorSet,character-method &,GeneColorSet,GeneColorSet-method
###   &,GeneColorSet,character-method
###   coloring<-,GeneColorSet,data.frame-method
###   coloring,GeneColorSet-method geneColor<-,GeneColorSet,factor-method
###   geneColor,GeneColorSet-method initialize,GeneColorSet-method
###   intersect,GeneColorSet,GeneColorSet-method
###   phenotypeColor<-,GeneColorSet,factor-method
###   phenotypeColor,GeneColorSet-method
###   phenotype<-,GeneColorSet,character-method
###   phenotype,GeneColorSet-method
###   setdiff,GeneColorSet,GeneColorSet-method show,GeneColorSet-method
###   union,GeneColorSet,GeneColorSet-method
###   [,GeneColorSet,numeric,ANY-method [,GeneColorSet,character,ANY-method
###   [[,GeneColorSet,numeric-method [[,GeneColorSet,character-method
###   $,GeneColorSet-method coloring<- coloring geneColor<- geneColor
###   phenotype<- phenotype phenotypeColor<- phenotypeColor
### Keywords: classes

### ** Examples

## Create a GeneColorSet from an ExpressionSet
data(sample.ExpressionSet)
gcs1 <- GeneColorSet(sample.ExpressionSet[100:109],
                     phenotype="imaginary")
gcs1
## or with color...
gcs2 <- GeneColorSet(sample.ExpressionSet[100:109],
                     phenotype="imaginary",
                     geneColor=factor(
                       rep(c("up", "down", "unchanged"),
                           length.out=10)),
                     phenotypeColor=factor(
                       rep(c("enhanced", "reduced"),
                           length.out=10)))
coloring(gcs2)

## recode geneColor of genes 1 and 4
coloring(gcs2)[c(1,4),"geneColor"] <- "down"
coloring(gcs2)
## reset, this time by gene name
coloring(gcs2)[c("31339_at", "31342_at"),"geneColor"] <- c("up", "up")
## usual 'factor' errors and warning apply:
coloring(gcs2)[c("31339_at", "31342_at"),"geneColor"] <- c("UP", "up")

gcs2[["31342_at"]]
try(gcs2[["31342_"]]) # no partial matching
gcs2$"31342" # 1 partial match ok



