### Name: exon.segment
### Title: Binary segmentation of exon data.
### Aliases: exon.segment
### Keywords: nonparametric

### ** Examples


# test code on an easy data set
set.seed(25)
gene <- rep(c("A", "B"), c(30,20))
eloc <- c(1:30, 1:20)
edat <- matrix(rnorm(500), 50, 10)
# changes for gene1 in samples 3 & 7
edat[1:30, 3] <- edat[1:30, 3] + rep(0.9*0:1, c(17, 13))
edat[1:30, 7] <- edat[1:30, 7] + rep(1.1*0:1, c(21, 9))
# changes for gene2 in samples 4 & 7
edat[31:50, 4] <- edat[31:50, 4] + rep(1.1*0:1, c(8, 12))
edat[31:50, 7] <- edat[31:50, 7] + rep(1.2*0:1, c(13, 7))
exon.segment(gene, eloc, edat)




