###################################################
### chunk number 1:  eval=FALSE
###################################################
## library(CALIB)
## calibReadMe()


###################################################
### chunk number 2: 
###################################################
library(CALIB)
path<-system.file("arraydata", package="CALIB")
dir(system.file("arraydata", package="CALIB")) 


###################################################
### chunk number 3: 
###################################################
datapath <- system.file("arraydata", package="CALIB")
targets <- readTargets("targets.txt",path=datapath)
targets


###################################################
### chunk number 4: 
###################################################
RG <- read.rg(targets$FileName,columns=list(Rf="CH1_NBC_INT",Gf="CH2_NBC_INT",Rb="CH1_SPOT_BKGD",Gb="CH2_SPOT_BKGD",RArea="CH1_SPOT_AREA",GArea="CH2_SPOT_AREA"),path=datapath)


###################################################
### chunk number 5: 
###################################################
filename <- "annotation.txt"
fullname <- file.path(datapath,filename)
annotation <- read.table(file=fullname,header=T,fill=T,quote="",sep="\t")
RG$genes <- annotation


###################################################
### chunk number 6: 
###################################################
types<-readSpotTypes(path=datapath)
types
spotstatus<-controlStatus(types,RG$genes)
RG$genes$Status<-spotstatus


###################################################
### chunk number 7: 
###################################################
concfile<-"conc.txt"
spike<-read.spike(RG,file=concfile,path=datapath)


###################################################
### chunk number 8: spikeci
###################################################
arraynum <- 1
plotSpikeCI(spike,array=arraynum)


###################################################
### chunk number 9: 
###################################################
parameter<-estimateParameter(spike,RG,bc=F,area=T,errormodel="M")


###################################################
### chunk number 10: spikehi
###################################################
plotSpikeHI(spike,parameter,array=arraynum)


###################################################
### chunk number 11: 
###################################################
array<-c(1,1,2,2)
condition<-c(1,2,2,1)
dye<-c(1,2,1,2)
idcol<-"CLONE_ID"
## here, we normalize the first ten genes as example.
cloneid<-RG$genes[1:10,idcol]
normdata<-normalizeData(RG,parameter,array,condition,dye,idcol=idcol,cloneid=cloneid)
normdata


