### Name: translate
### Title: DNA/RNA transcription and translation
### Aliases: transcribe cDNA dna2rna rna2dna codons codons,DNAString-method
###   codons,RNAString-method codons,MaskedDNAString-method
###   codons,MaskedRNAString-method translate translate,DNAString-method
###   translate,RNAString-method translate,DNAStringSet-method
###   translate,RNAStringSet-method translate,MaskedDNAString-method
###   translate,MaskedRNAString-method
### Keywords: methods manip

### ** Examples

  file <- system.file("extdata", "someORF.fa", package="Biostrings")
  x <- read.DNAStringSet(file, "fasta")
  x

  ## The first and last 1000 nucleotides are not part of the ORFs:
  x <- DNAStringSet(x, start=1001, end=-1001)

  ## Before calling translate() on an ORF, we need to mask the introns
  ## if any. We can get this information fron the SGD database
  ## (http://www.yeastgenome.org/).
  ## According to SGD, the 1st ORF (YAL001C) has an intron at 71..160
  ## (see http://db.yeastgenome.org/cgi-bin/locus.pl?locus=YAL001C)
  y1 <- x[[1]]
  mask1 <- Mask(length(y1), start=71, end=160)
  masks(y1) <- mask1
  y1
  translate(y1)

  ## Codons
  codons(y1)
  which(width(codons(y1)) != 3)
  codons(y1)[20:28]



