### Name: matchProbePair
### Title: Find "theoretical amplicons" mapped to a probe pair
### Aliases: matchProbePair matchProbePair,DNAString-method
###   matchProbePair,XStringViews-method
###   matchProbePair,MaskedDNAString-method
### Keywords: methods

### ** Examples

  library(BSgenome.Dmelanogaster.UCSC.dm3)
  subject <- Dmelanogaster$chr3R

  ## With 20-nucleotide forward and reverse probes:
  Fprobe <- "AGCTCCGAGTTCCTGCAATA"
  Rprobe <- "CGTTGTTCACAAATATGCGG"
  matchProbePair(Fprobe, Rprobe, subject) # 1 "theoretical amplicon"

  ## With shorter forward and reverse probes, the risk of having multiple
  ## "theoretical amplicons" increases:
  Fprobe <- "AGCTCCGAGTTCC"
  Rprobe <- "CGTTGTTCACAA"
  matchProbePair(Fprobe, Rprobe, subject) # 2 "theoretical amplicons"
  Fprobe <- "AGCTCCGAGTT"
  Rprobe <- "CGTTGTTCACA"
  matchProbePair(Fprobe, Rprobe, subject) # 9 "theoretical amplicons"



