### Name: align-utils
### Title: Utility functions related to sequence alignment
### Aliases: align-utils mismatch,AlignedXStringSet,missing-method
###   nmatch,PairwiseAlignedFixedSubject,missing-method
###   nmatch,PairwiseAlignedFixedSubjectSummary,missing-method
###   nmismatch,AlignedXStringSet,missing-method
###   nmismatch,PairwiseAlignedFixedSubject,missing-method
###   nmismatch,PairwiseAlignedFixedSubjectSummary,missing-method
###   mismatchTable mismatchTable,AlignedXStringSet-method
###   mismatchTable,QualityAlignedXStringSet-method
###   mismatchTable,PairwiseAlignedFixedSubject-method mismatchSummary
###   mismatchSummary,AlignedXStringSet-method
###   mismatchSummary,QualityAlignedXStringSet-method
###   mismatchSummary,PairwiseAlignedFixedSubject-method
###   mismatchSummary,PairwiseAlignedFixedSubjectSummary-method
###   coverage,AlignedXStringSet-method
###   coverage,PairwiseAlignedFixedSubject-method
###   coverage,PairwiseAlignedFixedSubjectSummary-method compareStrings
###   compareStrings,character,character-method
###   compareStrings,XString,XString-method
###   compareStrings,XStringSet,XStringSet-method
###   compareStrings,AlignedXStringSet,AlignedXStringSet-method
###   compareStrings,PairwiseAlignedFixedSubject,missing-method
###   consensusMatrix consensusMatrix,character-method
###   consensusMatrix,matrix-method consensusMatrix,list-method
###   consensusMatrix,XStringSet-method consensusMatrix,XStringViews-method
###   consensusMatrix,PairwiseAlignedFixedSubject-method consensusString
###   consensusString,ANY-method consmat consmat,ANY-method
### Keywords: methods

### ** Examples

  ## Compare two globally aligned strings
  string1 <- "ACTTCACCAGCTCCCTGGCGGTAAGTTGATC---AAAGG---AAACGCAAAGTTTTCAAG"
  string2 <- "GTTTCACTACTTCCTTTCGGGTAAGTAAATATATAAATATATAAAAATATAATTTTCATC"
  compareStrings(string1, string2)

  ## Create a consensus matrix
  nw1 <-
    pairwiseAlignment(AAStringSet(c("HLDNLKGTF", "HVDDMPNAL")), AAString("SMDDTEKMSMKL"),
      substitutionMatrix = "BLOSUM50", gapOpening = -3, gapExtension = -1)
  consensusMatrix(nw1)

  ## Examine the consensus between the bacteriophage phi X174 genomes
  data(phiX174Phage)
  phageConsmat <- consensusMatrix(phiX174Phage, baseOnly = TRUE)
  phageDiffs <- which(apply(phageConsmat, 2, max) < length(phiX174Phage))
  phageDiffs
  phageConsmat[,phageDiffs]

  ## Read in ORF data
  file <- system.file("extdata", "someORF.fa", package="Biostrings")
  orf <- read.DNAStringSet(file, "fasta")

  ## To illustrate, the following example assumes the ORF data
  ## to be aligned for the first 10 positions (patently false):
  orf10 <- DNAStringSet(orf, end=10)
  consensusMatrix(orf10, baseOnly=TRUE, freq=TRUE)
  consensusString(sort(orf10)[1:5])

  ## For the character matrix containing the "exploded" representation
  ## of the strings, do:
  as.matrix(orf10, use.names=FALSE)



