### Name: injectSNPs
### Title: SNP injection
### Aliases: injectSNPs injectSNPs,BSgenome-method SNPlocs_pkgname
###   SNPlocs_pkgname,BSgenome-method SNPcount SNPcount,BSgenome-method
###   SNPlocs SNPlocs,BSgenome-method available.SNPs
### Keywords: manip

### ** Examples

  ## Get the list of SNPlocs data packages currently available:
  available.SNPs()

  if (interactive()) {
    ## Make your choice and install with:
    source("http://bioconductor.org/biocLite.R")
    biocLite("SNPlocs.Hsapiens.dbSNP.20071016")
  }

  ## Inject SNPs from dbSNP into the Human genome:
  library(BSgenome.Hsapiens.UCSC.hg18)
  Hsapiens
  SNPlocs_pkgname(Hsapiens)

  HsWithSNPs <- injectSNPs(Hsapiens, "SNPlocs.Hsapiens.dbSNP.20071016")
  HsWithSNPs  # note the extra "with SNPs injected from ..." line
  SNPlocs_pkgname(HsWithSNPs)
  SNPcount(HsWithSNPs)
  SNPlocs(HsWithSNPs, "chr1")

  alphabetFrequency(Hsapiens$chr1)
  alphabetFrequency(HsWithSNPs$chr1)



