### Name: rgu34aPMID
### Title: Map between Manufacturer Identifiers and PubMed Identifiers
### Aliases: rgu34aPMID
### Keywords: datasets

### ** Examples

        x <- rgu34aPMID
        # Get the probe identifiers that are mapped to any PubMed ID
        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
    if(length(xx) > 0){
        # Get the PubMed identifiers for the first two probe identifiers
        xx[1:2]
        # Get the first one
        xx[[1]]
        if(interactive() && !is.null(xx[[1]]) && !is.na(xx[[1]])
           && require(annotate)){
            # Get article information as XML files
            xmls <- pubmed(xx[[1]], disp = "data")
            # View article information using a browser
            pubmed(xx[[1]], disp = "browser")
        }
    }



