### Name: rat2302PMID2PROBE
### Title: Map between PubMed Identifiers and Manufacturer Identifiers
### Aliases: rat2302PMID2PROBE
### Keywords: datasets

### ** Examples

    # Convert the object to a list
    xx <- as.list(rat2302PMID2PROBE)
    if(length(xx) > 0){
        # Get the probe identifiers for the first two PubMed identifiers
        xx[1:2]
        # Get the first one
        xx[[1]]
        if(interactive() && require(annotate)){
            # Get article information as XML files for a PubMed id
            xmls <- pubmed(names(xx)[1], disp = "data")
            # View article information using a browser
            pubmed(names(xx)[1], disp = "browser")
        }
    }



