### Name: hom.Mm.inpHOMSA
### Title: Map between IDs for genes in one organism to their predicted
###   paralogs in another
### Aliases: hom.Mm.inpAEDAE hom.Mm.inpANOGA hom.Mm.inpAPIME
###   hom.Mm.inpARATH hom.Mm.inpBOSTA hom.Mm.inpCAEBR hom.Mm.inpCAEEL
###   hom.Mm.inpCAERE hom.Mm.inpCANFA hom.Mm.inpCANGL hom.Mm.inpCIOIN
###   hom.Mm.inpCRYNE hom.Mm.inpDANRE hom.Mm.inpDEBHA hom.Mm.inpDICDI
###   hom.Mm.inpDROME hom.Mm.inpDROPS hom.Mm.inpENTHI hom.Mm.inpESCCO
###   hom.Mm.inpFUGRU hom.Mm.inpGALGA hom.Mm.inpGASAC hom.Mm.inpHOMSA
###   hom.Mm.inpKLULA hom.Mm.inpMACMU hom.Mm.inpMONDO hom.Mm.inpMUSMU
###   hom.Mm.inpORYSA hom.Mm.inpPANTR hom.Mm.inpRATNO hom.Mm.inpSACCE
###   hom.Mm.inpSCHPO hom.Mm.inpTETNI hom.Mm.inpXENTR hom.Mm.inpYARLI
### Keywords: datasets

### ** Examples

        x <- hom.Mm.inpAPIME
        # Get honeybee IDs that are paralogous to the pkg IDs
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five genes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        #Now for the reverse map (honeybee IDs back to pkg paralog)
        x <- revmap(hom.Mm.inpAPIME)
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five IDs
          xx[1:5]
          # Get the first one
          xx[[1]]
        }         

    ## Not run: 
##D         #For the most common organisms, we try to ensure that you can
##D         #map back to an Entrez Gene ID by providing you with necessary
##D         #maps in the related organism based annotation packages.  The
##D         #following example shows how to get from an Entrez Gene ID for
##D         #Human to Entrez Gene IDs for Mouse even though inparanoid does
##D         #not map to Entrez Gene IDs for either of these species.
##D 
##D         #You will have to include the appropriate packages for
##D         #humans:
##D         library("org.Hs.eg.db")
##D         #and for mouse:
##D         library("org.Mm.eg.db")
##D         #And of course you will need the inparanoid package:
##D         library("hom.Hs.inp.db")
##D 
##D         #Start with some Human Entrez Gene IDs
##D         humanEGIds <- c("4488","4487")
##D 
##D         #Inparanoid uses ensembl protein IDs so start with
##D         #those. Notice that there will be many protein IDs returned for
##D         #a typical gene since there are many possible translations.
##D         humanProtIds <- mget(humanEGIds,org.Hs.egENSEMBLPROT)
##D 
##D         #Map the IDs that we can from inparanoid. Notice that by design,
##D         #inparanoid only represents each gene product with a single
##D         #translation product. Therefore your list could slim down a lot
##D         #during this step.  Also, if the thing you are trying to match
##D         #up at this step has less than 100% seed status, you will not
##D         #find it in this step.
##D         rawMouseProtIds <- mget(unlist(humanProtIds),hom.Hs.inpMUSMU,ifnotfound=NA)
##D         #This also means that we need to clean up the NAs from our result
##D         mouseProtIds <- rawMouseProtIds[!is.na(rawMouseProtIds)]
##D 
##D         #Then use the mouse organism based packages to convert these IDs
##D         #back to an Entrez Gene ID again (this time for mouse). 
##D         mouseEGIds <- mget(unlist(mouseProtIds),org.Mm.egMGI2EG,ifnotfound=NA)
##D 
##D         #Now go ahead and have a look at the output
##D         mouseEGIds
##D     
## End(Not run)




